export default async function probashCatNewsApi() {
  const route = `https://backoffice.ajkal.us/category-news/9?_=${Date.now()}`;

  try {
    const data = await fetch(route, { cache: 'no-cache' });

    if (!data.ok) {
      throw new Error(`Failed to fetch data: ${data.status} ${data.statusText}`);
    }

    const probashData = await data.json();
    return probashData?.data;
  } catch (error) {
    console.error("Error fetching Probash category news:", error);
    return null;
  }
}
