export default async function breakingNewsCatNewsApi() {
  const route = `https://backoffice.ajkal.us/breaking-news`;

  try {
    // Fetch data with caching disabled
    let data = await fetch(route, {cache: 'no-cache'});

    // Check if the fetch was successful (HTTP status code 200)
    if (!data.ok) {
      throw new Error(`Failed to fetch data: ${data.statusText}`);
    }

    let breakingNewsData = await data.json();
    return breakingNewsData?.data; // Safely extract the data
  } catch (error) {
    console.error("Error fetching data:", error);
    return null; // Optionally, return null or handle fallback data here
  }
}
