"use client";

import React, { useEffect, useState } from "react";
import dynamic from "next/dynamic";

// Dynamically import the DiscussionEmbed to avoid SSR issues
const DiscussionEmbed = dynamic(
  () => import("disqus-react").then((mod) => mod.DiscussionEmbed),
  { ssr: false }
);

const DisqusComments = ({ singleNewsDetails }) => {
  const [pageUrl, setPageUrl] = useState("");

  useEffect(() => {
    if (typeof window !== "undefined") {
      setPageUrl(window.location.href);
    }
  }, []);

  const disqusShortname = "ajkal-us";
  const disqusConfig = {
    url: pageUrl,
    identifier: singleNewsDetails.id,
    title: singleNewsDetails.news_title,
  };

  return (
    <div className="disqus-container">
      {pageUrl && (
        <DiscussionEmbed shortname={disqusShortname} config={disqusConfig} />
      )}
    </div>
  );
};

export default DisqusComments;
