import formatDate from "@/utility/AdorshoLipi/Time/fornatDate";
import FallbackImages from "@/utility/FallBackImage/FallBackImages";
import "./SaraBissho.css";
import Link from "next/link";

const SaraBisshoSingleNews = ({ bannerList }) => {
  const repeatedNews = bannerList.slice(1, 7);

  return (
    <div>
      <div className="container px-0">
        <div className="row">
          {repeatedNews.length > 0 ? (
            repeatedNews.map((news, index) => (
              <div className="col-lg-4 pe-0" key={`${news.id}-${index}`}>
                <Link href={`/news-detail/${news?.id}`}>
                  <div className="non-featured-news-item">
                    <div className="card mb-2 border shadow-sm position-relative overflow-hidden news-items">
                      {/* Image container with zoom */}
                      <div className="image-wrapper overflow-hidden position-absolute top-0 start-0 w-100 h-100">
                        <FallbackImages
                          src={`https://ajkal.us/img/news/${news.title_img}`}
                          alt={news.title_img}
                          className="img-fluid sarabisso-img w-100 h-100 object-fit-cover"
                          width={200}
                          height={200}
                        />
                      </div>

                      {/* Gradient Overlay */}
                      <div className="gradient-overlay position-absolute bottom-0 start-0 w-100 h-100 z-1"></div>

                      {/* Text */}
                      <div className="card-body position-relative z-2">
                        <div className="text-start d-flex flex-column align-items-start justify-content-end h-100">
                          <h6 className="fw-normal text-white">
                            {news.news_title.split(" ").slice(0, 7).join(" ")}
                          </h6>
                          <span className="text-light">
                            {formatDate(news.news_time.slice(0, 10))}
                          </span>
                        </div>
                      </div>
                    </div>
                  </div>
                </Link>
              </div>
            ))
          ) : (
            <p>No non-featured news available</p>
          )}
        </div>
      </div>
    </div>
  );
};

export default SaraBisshoSingleNews;
