import FallbackImages from "@/utility/FallBackImage/FallBackImages";
import React from "react";
import "./ProbashNews.css";
import SectionHeader from "@/components/SectionHeader/SectionHeader";

const ProbashSingleNews = ({ probashData }) => {

  const probashDataFeature = probashData.filter(
    (news) => news.is_featured === 1
  );
  const probashDataNonFeature = probashData.filter(
    (news) => news.is_featured === 2
  );

  return (
    <div className="mb-lg-4 mb-2">
        <SectionHeader title="প্রবাস নিউজ"/>
      <div className="row">
        <div className="col-xl-4">
          {probashDataFeature.map((item, index) => (
            <div
              className="card text-start probash-news p-0 border shadow-sm"
              key={index}
            >
              <FallbackImages
                src={`https://ajkal.us/img/news/${item.title_img}`}
                alt={item.title_img}
                className="rounded-3 img-fluid probash-news"
                width={700}
                height={450}
              />
              <div className="card-body p-3">
                <h5 className="card-title">{item.news_title}</h5>
              </div>
            </div>
          ))}
        </div>
        <div className="col-xl-8">
          <div className="row">
            <div className="col">
              {probashDataNonFeature.slice(0, 2).map((item, index) => (
                <div
                  className="card text-start mb-3 p-0 shadow-sm border probash-nonfeature"
                  key={index}
                >
                  <div className="card-body p-3">
                    <FallbackImages
                      src={`https://ajkal.us/img/news/${item.title_img}`}
                      alt={item.title_img}
                      className="rounded-3 img-fluid"
                      width={700}
                      height={320}
                    />
                    <h6 className="card-title pt-3">{item.news_title}</h6>
                  </div>
                </div>
              ))}
            </div>
            <div className="col">
              {probashDataNonFeature.slice(2, 4).map((item, index) => (
                <div
                  className="card text-start p-0 shadow-sm border mb-3 probash-nonfeature"
                  key={index}
                >
                  <div className="card-body p-3">
                    <FallbackImages
                      src={`https://ajkal.us/img/news/${item.title_img}`}
                      alt={item.title_img}
                      className="rounded-3 img-fluid"
                      width={700}
                      height={300}
                    />
                    <h6 className="card-title pt-3">{item.news_title}</h6>
                  </div>
                </div>
              ))}
            </div>
            <div className="col">
              {probashDataNonFeature.slice(4, 6).map((item, index) => (
                <div
                  className="card text-start p-0 shadow-sm border mb-3 probash-nonfeature-2"
                  key={index}
                >
                  <div className="card-body p-3">
                    <FallbackImages
                      src={`https://ajkal.us/img/news/${item.title_img}`}
                      alt={item.title_img}
                      className="rounded-3 img-fluid"
                      width={700}
                      height={300}
                    />
                    <h6 className="card-title pt-3">{item.news_title}</h6>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ProbashSingleNews;
