"use client";
import Image from "next/image";
import Link from "next/link";
import { Swiper, SwiperSlide } from "swiper/react";
// No need to import navigation or pagination modules
import "swiper/css";
import "./FeatureNews.css";

const FeatureSlide = ({ spotListData }) => {
  // Only take first 4 items
  const displayedData = spotListData ? spotListData.slice(0, 4) : [];

  return (
    <div className="mb-4">
      {displayedData.length > 0 ? (
        <Swiper
          spaceBetween={20}
          slidesPerView={4}
          loop={false} // no loop
          navigation={false} // no arrows
          pagination={false} // no dots
          autoplay={false} // no autoplay
          // You can remove modules prop entirely since no pagination/navigation/autoplay
        >
          {displayedData.map((data, index) => (
            <SwiperSlide key={index}>
              <Link href={`/news-detail/${data?.id}`}>
                <div className="card rounded-2 shadow-sm feature-cards">
                  <div className="card-body">
                    <div className="text-site feature-titels pt-2 fs-5 mb-3">
                      {data.news_title.split(" ").slice(0, 8).join(" ")}
                    </div>
                  </div>
                  <Image
                    src={`https://ajkal.us/img/news/${data.title_img}`}
                    alt={data.title_img}
                    title="Card Image"
                    className="card-img-top rounded-0 custom-class rounded-2 "
                    width={1920}
                    height={160}
                    style={{ objectFit: "cover" }}
                  />
                </div>
              </Link>
            </SwiperSlide>
          ))}
        </Swiper>
      ) : (
        <div>No epapers available</div>
      )}
    </div>
  );
};

export default FeatureSlide;
