"use client";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import { useState } from "react";
import Button from "react-bootstrap/Button";
import Offcanvas from "react-bootstrap/Offcanvas";
import { RiMenu3Fill } from "react-icons/ri";

const MobileMenu = ({ allCategoryData }) => {
  const [show, setShow] = useState(false);
  const handleClose = () => setShow(false);
  const handleShow = () => setShow(true);
  return (
    <div>
      <Button
        variant="primary"
        onClick={handleShow}
        className="mobile-menu me-3"
        style={{ lineHeight: "0" }}
      >
        <RiMenu3Fill />
      </Button>

      <Offcanvas
        show={show}
        onHide={handleClose}
        className="w-100 off-canvas-menu"
      >
        <Offcanvas.Header closeButton>
          <Offcanvas.Title>
            <Link href="/" className="navbar-brand">
              <Image
                src="https://ajkal.us/img/settings/logo_red.png"
                alt="Logo"
                width={150}
                height={50}
                title="Site Logo"
              />
            </Link>
          </Offcanvas.Title>
        </Offcanvas.Header>
        <Offcanvas.Body>
          <div className="row justify-content-center align-items-center g-2 text-center">
            <div className="col-6">
              {/* First half of the categories */}
              {Array.isArray(allCategoryData) && allCategoryData.length > 0
                ? allCategoryData
                    .slice(0, Math.ceil(allCategoryData.length / 2))
                    .map((link) => (
                      <Link
                        href={`/${link.name}/${link.id}`}
                        passHref
                        key={link.id}
                        onClick={handleClose} // Close off-canvas on click
                      >
                        <p className="text-site fw-bold py-2">
                          {link.name_bangla}
                        </p>
                      </Link>
                    ))
                : null}
            </div>
            <div className="col-6">
              {/* Second half of the categories */}
              {Array.isArray(allCategoryData) && allCategoryData.length > 0
                ? allCategoryData
                    .slice(Math.ceil(allCategoryData.length / 2))
                    .map((link) => (
                      <Link
                        href={`/${link.name}/${link.id}`}
                        passHref
                        key={link.id}
                        onClick={handleClose} // Close off-canvas on click
                      >
                        <p className="text-site fw-bold py-2">
                          {link.name_bangla}
                        </p>
                      </Link>
                    ))
                : null}
            </div>

            <div className="col-12">
              <div className="mt-5">
                <div>
                  <div className="fs-3 text-black mb-0 sompadok">
                    <span>সম্পাদক ও প্রকাশক : </span>
                    <span className="pe-3">শাহ্‌ নেওয়াজ</span>
                  </div>
                </div>
                <div className="text-lg-start text-center">
                  <div className="text-black mb-0 pt-3">
                    ফোন: <span>+1646 267-7751</span> ফ্যাক্স:{" "}
                    <span>718-865-9130</span>
                    <span>
                      <br />
                      ঠিকানাঃ 71-16 35th Ave, Jackson Heights, NY 11372, USA.
                    </span>
                  </div>
                  <div className="text-black mb-0">
                    ইমেইল: <span>ajkalnews@gmail.com, </span>
                    <span>editor@ajkalusa.com</span>
                  </div>
                  <div className="text-black text-lg-start text-center mb-0 pt-0">
                    কপিরাইট © ২০২৪ সাপ্তাহিক আজকাল কর্তৃক সর্বসত্ব ® সংরক্ষিত
                  </div>
                </div>
              </div>
            </div>
            <div className="col-12">
              <div className="pt-4">
                <div className="text-center mb-0">
                  <small>
                    এই ওয়েবসাইটের কোনো লেখা, ছবি, অডিও, ভিডিও <br /> অনুমতি
                    ছাড়া ব্যবহার বেআইনি।
                  </small>
                </div>
                <div className="">
                  <small>
                    Developed With Love By
                    <Link
                      className="ps-2"
                      style={{ color: "orange" }}
                      href="https://flixzaglobal.com/"
                      target="_blank"
                    >
                      GoFlixza
                    </Link>
                  </small>
                </div>
              </div>
            </div>
          </div>
        </Offcanvas.Body>
      </Offcanvas>
    </div>
  );
};

export default MobileMenu;
