"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Recommendations = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _utils = require("./utils");
var _constants = require("./constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function () { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); } // Constants
var Recommendations = exports.Recommendations = /*#__PURE__*/function (_React$Component) {
  _inherits(Recommendations, _React$Component);
  var _super = _createSuper(Recommendations);
  function Recommendations() {
    _classCallCheck(this, Recommendations);
    return _super.apply(this, arguments);
  }
  _createClass(Recommendations, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.loadInstance();
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      if (this.props === nextProps) return false;
      return (0, _utils.shallowComparison)(this.props, nextProps);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.loadInstance();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.cleanInstance();
    }
  }, {
    key: "getDisqusConfig",
    value: function getDisqusConfig(config) {
      return function () {
        this.page.identifier = config.identifier;
        this.page.url = config.url;
        this.page.title = config.title;
        this.language = config.language;
      };
    }
  }, {
    key: "loadInstance",
    value: function loadInstance() {
      if (typeof window !== 'undefined' && window.document) {
        window.disqus_config = this.getDisqusConfig(this.props.config);
        if (window.document.getElementById(_constants.RECOMMENDATIONS_SCRIPT_ID)) {
          this.reloadInstance();
        } else {
          (0, _utils.insertScript)("https://".concat(this.props.shortname, ".disqus.com/recommendations.js"), _constants.RECOMMENDATIONS_SCRIPT_ID, window.document.body);
        }
      }
    }
  }, {
    key: "reloadInstance",
    value: function reloadInstance() {
      if (window && window.DISQUS_RECOMMENDATIONS) {
        window.DISQUS_RECOMMENDATIONS.reset({
          reload: true
        });
      }
    }
  }, {
    key: "cleanInstance",
    value: function cleanInstance() {
      (0, _utils.removeScript)(_constants.RECOMMENDATIONS_SCRIPT_ID, window.document.body);
      try {
        delete window.DISQUS_RECOMMENDATIONS;
      } catch (error) {
        window.DISQUS_RECOMMENDATIONS = undefined;
      }
      var recommendations = window.document.getElementById(_constants.RECOMMENDATIONS_ID);
      if (recommendations) {
        while (recommendations.hasChildNodes()) {
          recommendations.removeChild(recommendations.firstChild);
        }
      }
      (0, _utils.removeResources)();
    }
  }, {
    key: "render",
    value: function render() {
      // eslint-disable-next-line no-unused-vars
      var _this$props = this.props,
        shortname = _this$props.shortname,
        config = _this$props.config,
        rest = _objectWithoutProperties(_this$props, ["shortname", "config"]);
      return /*#__PURE__*/_react["default"].createElement("div", _extends({}, rest, {
        id: _constants.RECOMMENDATIONS_ID
      }));
    }
  }]);
  return Recommendations;
}(_react["default"].Component);
Recommendations.propTypes = {
  shortname: _propTypes["default"].string.isRequired,
  config: _propTypes["default"].shape({
    identifier: _propTypes["default"].string,
    url: _propTypes["default"].string,
    title: _propTypes["default"].string,
    language: _propTypes["default"].string
  })
};