// app/layout.js
import "bootstrap/dist/css/bootstrap.min.css";
// import "bootstrap/dist/js/bootstrap.bundle.min.js"; // ✅ only if you need dropdowns, modals etc.
import "./globals.css";
import { Toaster } from "react-hot-toast";
import Header from "@/components/Header/Header";
import Footer from "@/components/Footer/Footer";
import ScrollToTopButton from "@/utility/ScrollToTopButton/ScrollToTopButton";

import localFont from "next/font/local"; // ✅ built-in for fonts

// Custom Shurjo font setup
const shurjo = localFont({
  display: "swap",
  src: [
    {
      path: "./Font/Shurjo/Shurjo-bold.ttf",
      weight: "700",
      style: "normal",
    },
    {
      path: "./Font/Shurjo/Shurjo-Regular.ttf",
      weight: "400",
      style: "normal",
    },
  ],
  variable: "--font-shurjo", // ✅ optional, lets you use CSS var
});

export const metadata = {
  title: "My Next.js 14 Project",
  description: "Using Bootstrap + Shurjo Font + Custom Layout",
};

export default function RootLayout({ children }) {
  return (
    <html lang="bn">
      <body className={shurjo.className}>
        <Toaster position="top-center" reverseOrder={false} />
        <Header />
        <main>{children}</main>
        <ScrollToTopButton />
        <Footer />
      </body>
    </html>
  );
}
